/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
overall_score();

/**
 * Performs the overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();

    // let models = get_model_list();
    let models = ["M1", "T1"];

    let occupants = ["DRIVER"];

    /* The following objects will be populated with values for each occupant */
    let head_neck_score;
    let head_neck_points;
    let chest_score;
    let chest_points;
    let abdomen_score;
    let abdomen_points;
    let pelvis_score;
    let pelvis_points;
    let occ_score;

    let status = { success: true, missing: [], invalid: [] };

    let total_possible = 2.5;
    let brown = total_possible * 0.334;
    let orange = total_possible * 0.667;
    let yellow = total_possible * 0.999;

    let total_possible_sum = 10;
    let brown_sum = total_possible_sum * 0.334;
    let orange_sum = total_possible_sum * 0.667;
    let yellow_sum = total_possible_sum * 0.999;

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} overall score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Body region final scores */
            // head_neck_score[occ] = get_variable_value(status, `${m}_${occ}_HEAD_NECK_FINAL_SCORE`, "float");
            // head_neck_score_pass[occ] = get_variable_value(
            //     status,
            //     `${m}_${occ}_HEAD_NECK_FINAL_PASSENGER_SCORE`,
            //     "float"
            // );
            // chest_abdomen_score[occ] = get_variable_value(status, `${m}_${occ}_CHEST_ABDOMEN_FINAL_SCORE`, "float");
            // knee_femur_pelvis_score[occ] = get_variable_value(
            //     status,
            //     `${m}_${occ}_KNEE_FEMUR_PELVIS_FINAL_SCORE`,
            //     "float"
            // );
            // lower_leg_foot_ankle_score[occ] = get_variable_value(
            //     status,
            //     `${m}_${occ}_LOWER_LEG_FOOT_ANKLE_FINAL_SCORE`,
            //     "float"
            // );

            // subjective modifier section

            let dcp = getModifierValue(status, "M1_HEAD_POLE_CONTACT_MODIFIER");
            let damage = getModifierValue(status, "M1_DAMAGE_MODIFIER");
            let had = getModifierValue(status, "M1_HEAD_AIRBAG_DEPLOYMENT_MODIFIER");
            let sl = getModifierValue(status, "M1_SHOULDER_LOAD_MODIFIER");
            let cvc = getModifierValue(status, "M1_CHEST_VISCOUS_CRITERION_MODIFIER");
            let cad = getModifierValue(status, "M1_CHEST_AIRBAG_DEPLOYMENT_MODIFIER");
            let avc = getModifierValue(status, "M1_ABDOMEN_VISCOUS_CRITERION_MODIFIER");
            let aad = getModifierValue(status, "M1_ABDOMEN_AIRBAG_DEPLOYMENT_MODIFIER");
            let pad = getModifierValue(status, "M1_PELVIS_AIRBAG_DEPLOYMENT_MODIFIER");
            let head_total_mod;
            let chest_total_mod;
            let abdomen_total_mod;

            dcp = dcp * 20;
            damage = damage * 20;
            had = had * 4;
            head_total_mod = dcp + damage + had;
            head_total_mod = Math.max(head_total_mod, -100);
            sl = sl * 20;
            cvc = cvc * 20;
            cad = cad * 4;
            chest_total_mod = sl + cvc + cad;
            chest_total_mod = Math.max(chest_total_mod, -100);
            avc = avc * 20;
            aad = aad * 4;
            abdomen_total_mod = avc + aad;
            abdomen_total_mod = Math.max(abdomen_total_mod, -100);
            pad = pad * 4;

            new Variable(templ, `DCP`, `DCP_MOD`, dcp.toString(), "String", false, true);
            new Variable(templ, `DAMAGE`, `DAMAGE_MOD`, damage.toString(), "String", false, true);
            new Variable(templ, `HAD`, `HAD_MOD`, had.toString(), "String", false, true);
            new Variable(templ, `HEAD_TOTAL_MOD`, `HEAD_TOTAL_MOD`, head_total_mod.toString(), "String", false, true);
            new Variable(templ, `SL`, `SL_MOD`, sl.toString(), "String", false, true);
            new Variable(templ, `CVC`, `CVC_MOD`, cvc.toString(), "String", false, true);
            new Variable(templ, `CAD`, `CAD_MOD`, cad.toString(), "String", false, true);
            new Variable(
                templ,
                `CHEST_TOTAL_MOD`,
                `CHEST_TOTAL_MOD`,
                chest_total_mod.toString(),
                "String",
                false,
                true
            );
            new Variable(templ, `AVC`, `AVC_MOD`, avc.toString(), "String", false, true);
            new Variable(templ, `AAD`, `AAD_MOD`, aad.toString(), "String", false, true);
            new Variable(
                templ,
                `ABDOMEN_TOTAL_MOD`,
                `ABDOMEN_TOTAL_MOD`,
                abdomen_total_mod.toString(),
                "String",
                false,
                true
            );
            new Variable(templ, `PAD`, `PAD_MOD`, pad.toString(), "String", false, true);

            // subjective modifiers end

            //test and active modifier section
            let hpd;
            let rollover;
            let door_open = getModifierValue(status, "M1_DOOR_OPENING_MODIFIER");
            let door_detatch;
            let restraint;
            let pubic_mod = get_variable_value(status, "M1_DRIVER_PELVIS_FORCE_SCORE");
            let lumbary = get_variable_value(status, "M1_DRIVER_LUMBAR_SHEAR_SCORE");
            let lumbarz = get_variable_value(status, "M1_DRIVER_LUMBAR_AXIAL_SCORE");
            let lumbarx = get_variable_value(status, "M1_DRIVER_LUMBAR_TORSION_SCORE");
            let test_pen;
            let occ_pen;
            let total_mod;
            let total_mod_points;

            hpd = getModifierValue(status, "M1_HPD_MODIFIER");
            hpd = hpd * 2;
            rollover = getModifierValue(status, "M1_ROLLOVER_MODIFIER");
            rollover = rollover * 4;
            door_detatch = getModifierValue(status, "M1_DOOR_DETACHMENT_MODIFIER");
            door_detatch = door_detatch * 20;
            restraint = getModifierValue(status, "M1_RESTRAINT_FAILURE_MODIFIER");
            restraint = restraint * 20;

            if (pubic_mod == 0) {
                pubic_mod = -25;
            } else {
                pubic_mod = 0;
            }
            if (lumbary == -1) {
                lumbary = -25;
            }
            if (lumbarz == -1) {
                lumbarz = -25;
            }
            if (lumbarx == -1) {
                lumbarx = -25;
            }

            test_pen = hpd + rollover + door_open + door_detatch + restraint;
            let test_pen_100 = Math.max(test_pen, -100);
            occ_pen = pubic_mod + lumbarx + lumbary + lumbarz;
            let occ_pen_100 = Math.max(occ_pen, -100);
            total_mod = test_pen + occ_pen;
            let total_mod_100 = Math.max(total_mod, -100);
            total_mod_points = total_mod_100 * 0.1;

            new Variable(templ, `HPD`, `HPD_MOD`, hpd.toString(), "String", false, true);
            new Variable(templ, `ROLLOVER`, `ROLLOVER_MOD`, rollover.toString(), "String", false, true);
            new Variable(templ, `DOOR_OPEN`, `DOOR_OPENING_MOD`, door_open.toString(), "String", false, true);
            new Variable(templ, `DOOR_DETATCH`, `DOOR_DETACHMENT_MOD`, door_detatch.toString(), "String", false, true);
            new Variable(templ, `RESTRAINT`, `RESTRAINT_FAILURE_MOD`, restraint.toString(), "String", false, true);
            new Variable(templ, `PUBIC_MOD`, `PUBIC_FORCE_MOD`, pubic_mod.toString(), "String", false, true);
            new Variable(templ, `LUMBAR_Y_MOD`, `LUMBAR_Y_FORCE_MOD`, lumbary.toString(), "String", false, true);
            new Variable(templ, `LUMBAR_Z_MOD`, `LUMBAR_Z_FORCE_MOD`, lumbarz.toString(), "String", false, true);
            new Variable(templ, `LUMBAR_X_MOD`, `LUMBAR_X_MOMENT_MOD`, lumbarx.toString(), "String", false, true);
            new Variable(templ, `TEST_PEN`, `TEST_PENALTIES_TOTAL`, test_pen_100.toString(), "String", false, true);
            new Variable(templ, `OCC_PEN`, `OCCUPANT_PENALTIES_TOTAL`, occ_pen_100.toString(), "String", false, true);
            new Variable(templ, `TOTAL_PEN`, `PENALTIES_TOTAL`, total_mod_100.toString(), "String", false, true);
            new Variable(
                templ,
                `TOTAL_PEN_POINTS`,
                `PENALTIES_TOTAL_POINTS`,
                total_mod_points.toString(),
                "String",
                false,
                true
            );

            //end test and active modifier section

            head_neck_score = parseFloat(get_variable_value(status, `M1_DRIVER_HEAD_FINAL_SCORE`, "float", false));
            let head_neck_score_mod = head_neck_score + head_total_mod;
            head_neck_score_mod = Math.max(head_neck_score_mod, 0);
            head_neck_points = head_neck_score_mod * 0.025;
            head_neck_points = replaceNaNWithMissing(head_neck_points);
            new Variable(
                templ,
                `HEAD_NECK_SCORE_MOD`,
                `HEAD_NECK_SCORE_MOD`,
                head_neck_score_mod.toString(),
                "String",
                false,
                true
            );

            chest_score = get_variable_value(status, `M1_DRIVER_CHEST_FINAL_SCORE`, "float", false);
            chest_score = replaceNaNWithMissing(chest_score);
            let chest_score_mod = chest_score + chest_total_mod;
            chest_score_mod = Math.max(chest_score_mod, 0);
            chest_points = chest_score_mod * 0.025;
            chest_points = replaceNaNWithMissing(chest_points);
            new Variable(
                templ,
                `CHEST_SCORE_MOD`,
                `CHEST_SCORE_MOD`,
                chest_score_mod.toString(),
                "String",
                false,
                true
            );

            abdomen_score = get_variable_value(status, `M1_DRIVER_ABDOMEN_SCORE`, "float", false);
            abdomen_score = replaceNaNWithMissing(abdomen_score);
            let abdomen_score_mod = abdomen_score + abdomen_total_mod;
            abdomen_score_mod = Math.max(abdomen_score_mod, 0);
            abdomen_points = abdomen_score_mod * 0.025;
            abdomen_points = replaceNaNWithMissing(abdomen_points);
            new Variable(
                templ,
                `ABDOMEN_SCORE_MOD`,
                `ABDOMEN_SCORE_MOD`,
                abdomen_score_mod.toString(),
                "String",
                false,
                true
            );

            pelvis_score = get_variable_value(status, `M1_DRIVER_PELVIS_FORCE_SCORE`, "float", false);
            pelvis_score = replaceNaNWithMissing(pelvis_score);
            let pelvis_score_mod = pelvis_score + pad;
            pelvis_score_mod = Math.max(pelvis_score_mod, 0);
            pelvis_points = pelvis_score_mod * 0.025;
            pelvis_points = replaceNaNWithMissing(pelvis_points);
            new Variable(
                templ,
                `PELVIS_SCORE_MOD`,
                `PELVIS_SCORE_MOD`,
                pelvis_score_mod.toString(),
                "String",
                false,
                true
            );

            /* Body region capping limits */
            let head_neck_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_NECK_CAPPING_LIMIT`, "string");
            let chest_capping_limit = get_variable_value(status, `${m}_${occ}_CHEST_CAPPING_LIMIT`, "string");

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            occ_score = 0;

            /* If we have all the required variables, calculate the final scores */

            /* Overall occupant score is sum of body region scores. */

            occ_score = head_neck_points + chest_points + abdomen_points + pelvis_points;
            LogPrint(`${m} ${occ} overall score = ${occ_score[occ]}`);

            occ_score = replaceNaNWithMissing(occ_score);

            /* Only remove the overall occupant capping limit if none of the body region
             * capping limits were exceeded. */

            // Head Excursion Scoring Section //
            let neck_up_ex = get_variable_value(status, `${m}_${occ}_NECK_UPPER_EXTENSION_SCORE`, "string");
            let neck_lo_ex = get_variable_value(status, `${m}_${occ}_NECK_LOWER_EXTENSION_SCORE`, "string");
            let neck_up_flex = get_variable_value(status, `${m}_${occ}_NECK_UPPER_FLEXION_SCORE`, "string");
            let neck_lo_flex = get_variable_value(status, `${m}_${occ}_NECK_LOWER_FLEXION_SCORE`, "string");
            let neck_up_ax = get_variable_value(status, `${m}_${occ}_NECK_UPPER_AXIAL_SCORE`, "string");
            let neck_lo_ax = get_variable_value(status, `${m}_${occ}_NECK_LOWER_AXIAL_SCORE`, "string");
            let head_excursion_capping;
            if (
                [
                    neck_up_ex,
                    neck_lo_ex,
                    neck_up_flex,
                    neck_lo_flex,
                    neck_up_ax,
                    neck_lo_ax,
                    head_neck_score,
                    chest_score,
                    abdomen_score
                ].some((v) => v === 0)
            ) {
                head_excursion_capping = "YES";
            } else {
                head_excursion_capping = "NO";
            }

            let brown_var = new Variable(
                templ,
                `BROWN`,
                `Brown condtional format`,
                brown.toString(),
                "String",
                false,
                true
            );
            let orange_var = new Variable(
                templ,
                `ORANGE`,
                `Orange condtional format`,
                orange.toString(),
                "String",
                false,
                true
            );
            let yellow_var = new Variable(
                templ,
                `YELLOW`,
                `Yellow condtional format`,
                yellow.toString(),
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `BROWN_SUM`,
                `Brown sum condtional format`,
                brown_sum.toString(),
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `ORANGE_SUM`,
                `Orange sum condtional format`,
                orange_sum.toString(),
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `YELLOW_SUM`,
                `Yellow sum condtional format`,
                yellow_sum.toString(),
                "String",
                false,
                true
            );

            let head_excursion_capping_var = new Variable(
                templ,
                `HEAD_EXCURSION_CAPPING`,
                `Head excursion capping`,
                head_excursion_capping.toString(),
                "String",
                false,
                true
            );

            let head_neck_points_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_NECK_POINTS`,
                `Final ${occ} Head and Neck Points`,
                head_neck_points.toString(),
                "String",
                false,
                true
            );
            let chest_points_var = new Variable(
                templ,
                `${m}_${occ}_CHEST_POINTS`,
                `Final ${occ} Chest Points`,
                chest_points.toString(),
                "String",
                false,
                true
            );
            let abdomen_points_var = new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_POINTS`,
                `Final ${occ} Abdomen Points`,
                abdomen_points.toString(),
                "String",
                false,
                true
            );
            let pelvis_points_var = new Variable(
                templ,
                `${m}_${occ}_PELVIS_POINTS`,
                `Final ${occ} Pelvis Points`,
                pelvis_points.toString(),
                "String",
                false,
                true
            );

            let overall_occ_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_OVERALL_SCORE`,
                `Overall ${occ} score`,
                occ_score.toString(),
                "String",
                false,
                true
            );
            let total_occ_points = occ_score + total_mod * 0.1;
            total_occ_points = Math.max(total_occ_points, 0);
            let overall_occ_score_mod_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_FINAL_SCORE`,
                `Overall ${occ} score with modifiers`,
                total_occ_points.toString(),
                "String",
                false,
                true
            );
        }
    }

    let rac_sim_variables = [
        "M1_DRIVER_HEAD_HIC_HIC_RACSIM",
        "M1_DRIVER_HEAD_THREE_MS_EXCEEDENCE_RACSIM",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_01_RACSIM",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_02_RACSIM",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_03_RCSIM",
        "M1_DRIVER_ABDOMEN_COMPRESSION_MAX_01_RACSIM",
        "M1_DRIVER_ABDOMEN_COMPRESSION_MAX_02_RACSIM",
        "M1_DRIVER_PELVIS_FORCE_RACSIM"
    ];

    let rac_test_variables = [
        "T1_DRIVER_HEAD_HIC_HIC_RACTEST",
        "T1_DRIVER_HEAD_THREE_MS_EXCEEDENCE_RACTEST",
        "T1_DRIVER_CHEST_COMPRESSION_MAX_01_RACTEST",
        "T1_DRIVER_CHEST_COMPRESSION_MAX_02_RACTEST",
        "T1_DRIVER_CHEST_COMPRESSION_MAX_03_RATEST",
        "T1_DRIVER_ABDOMEN_COMPRESSION_MAX_01_RACTEST",
        "T1_DRIVER_ABDOMEN_COMPRESSION_MAX_02_RACTEST",
        "T1_DRIVER_PELVIS_FORCE_RACTEST"
    ];

    let dac_variables = [
        "M1_DRIVER_HEAD_HIC_HIC_DAC",
        "M1_DRIVER_HEAD_THREE_MS_EXCEEDENCE_DAC",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_01_DAC",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_02_DAC",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_03_DAC",
        "M1_DRIVER_ABDOMEN_COMPRESSION_MAX_01_DAC",
        "M1_DRIVER_ABDOMEN_COMPRESSION_MAX_02_DAC",
        "M1_DRIVER_PELVIS_FORCE_DAC"
    ];

    /** Creates missing variable for RACSIM and AC_LIMIT */
    for (let i = 0; i < rac_sim_variables.length; i++) {
        get_variable_value(status, rac_sim_variables[i], "float", true);
        get_variable_value(status, rac_sim_variables[i].replace("RACSIM", "AC_LIMIT"), "float", true);
    }

    /** Initialise "DAC" to "Pass" */
    let dac = "Pass";

    /** Creates missing variable for RACTEST,
     * 1. Sets DAC to missing if RACTEST is missing
     * 2. Sets DAC to missing if RACTEST is bigger than 0.5 but RACSIM is missing and sets component DAC to missing
     * 3. Sets DAC to missing if RACTEST is bigger than 0.5 but component DAC is missing
     * 4. Sets DAC to fail if RACTEST is bigger than or equal to 0.5 and component DAC is bigger than or equal to 0.3 */
    for (let i = 0; i < rac_test_variables.length; i++) {
        let sim_value = get_variable_value(status, rac_sim_variables[i], "float");
        let rac_test_value = get_variable_value(status, rac_test_variables[i], "float", true);
        /* Replace RACTEST with DAC */
        let dac_value = get_variable_value(status, dac_variables[i], "float");
        if (rac_test_value == "Missing" || isNaN(rac_test_value) || rac_test_value == null) {
            dac = "Missing";
        } else if (rac_test_value >= 0.5) {
            if (sim_value == "Missing" || isNaN(sim_value) || sim_value == null) {
                dac = "Missing";
                new Variable(templ, dac_variables[i], "DAC", "Missing", "General", false, true);
            } else if (dac_value == "Missing" || isNaN(dac_value) || dac_value == null) {
                dac = "Missing";
                new Variable(templ, dac_variables[i], "DAC", "Missing", "General", false, true);
            } else if (dac_value >= 0.3) {
                dac = "Fail";
            }
        } else if (rac_test_value < 0.5 && (sim_value == "Missing" || isNaN(sim_value) || sim_value == null)) {
            /* Sometimes RACTEST might pass but RACSIM is missing, in this case we need to create an empty variable for the components DAC */
            new Variable(templ, dac_variables[i], "DAC", "", "General", false, true);
        }
    }
    new Variable(templ, "DAC", "DAC", dac, "General", false, true);
}
